<div class="row">
	<div class="col-sm-6 blog-swiper">
		<div class="swiper" id="swiper-blog">
  			<div class="swiper-wrapper">
			<?php
			$args = array(
				'post_type' => 'post',
				'posts_per_page' => 3,
				//'offset'         => 3
			);

			$query = new WP_Query( $args );

			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post(); 
					?>

					<?php
					$post_ID = get_the_ID();
					$post_title = get_the_title();
					$post_link = get_the_permalink();
					$post_date = get_the_date('d.m.Y');
					$post_desc = get_the_excerpt();
					if ( has_post_thumbnail() ) {
						$post_bg = get_the_post_thumbnail_url($post_ID, 'medium_large');
					} else {
						$post_bg = get_template_directory_uri().'/img/dummy-post.png';
					}
					?>

					<div class="swiper-slide">

						<article class="article-item">

							<div class="post-featured" style="background-image: url(<?php echo $post_bg; ?>);">

								<div class="cover"></div>

								<div class="post-meta">
									<div class="categoria">
									<?php
									$categories = get_the_category();
									if ( ! empty( $categories ) ) {
										echo esc_html( $categories[0]->name );
									}
									?>
									</div>
								</div>

								<div class="post-date">
									<div class="data"><?php echo $post_date;?></div>
								</div>

								<div class="post-title">
									<a href="<?php echo $post_link;?>">
										<h4><?php echo $post_title;?></h4>
									</a>
								</div>

							</div>

						</article>
						<!-- end .article-item -->				
					
					</div>
					<!-- end .swiper-slide -->

				<?php
				}
			}
			?>
			</div>
		</div>
		<div class="swiper-pagination blog-pagination"></div>
	</div>
		
<?php 
 
?>
	<div class="col-sm-6 blog-static">
		<div class="posts-wrapper">
			<?php
			
			$args = array(
				'post_type' => 'post',
				'posts_per_page' => 2,
				'offset'         => 3
			);
			
			$query = new WP_Query($args);
			?>

			<?php if($query ->have_posts()) : ?>
				
				<?php while($query ->have_posts()) : $query ->the_post(); ?>
				
					<?php
					$post_ID = get_the_ID();
					$post_title = get_the_title();
					$post_link = get_the_permalink();
					$post_date = get_the_date('d.m.Y');
					$post_desc = get_the_excerpt();
					if ( has_post_thumbnail() ) {
						$post_bg = get_the_post_thumbnail_url($post_ID, 'medium');
					} else {
						$post_bg = get_template_directory_uri().'/img/dummy-post.png';
					}
					?>
						
					<article class="article-item">

						<div class="post-featured">
							<a href="<?php echo $post_link; ?>">
								<img src="<?php echo $post_bg; ?>" alt="" title="" />
							</a>
						</div>										
					
						<div class="post-meta">
							<div class="row">
								<div class="col-12">
									<div class="data"><?php echo $post_date;?></div>
								</div>
								<div class="col-12">
									<div class="categoria">
									<?php
									$categories = get_the_category();
									if ( ! empty( $categories ) ) {
										echo esc_html( $categories[0]->name );
									}
									?>
									</div>
								</div>
							</div>
						</div>
						
						<div class="post-title">
							<a href="<?php echo $post_link;?>">
								<h4><?php echo $post_title;?></h4>
							</a>
						</div>
						
					</article>
					<!-- end .article-item -->
						
				<?php endwhile; ?>
				
				<?php
				wp_reset_postdata();
				?>

			<?php else: ?>
				Nenhum artigo relacionado encontrado.
			<?php endif; ?>
		
		</div>
		<!-- end .posts-wrapper -->
	</div>
</div>

<div class="cta">
	<a href="<?php echo get_home_url();?>/noticias/">Ver mais</a>
</div>

<script>
const swiper_clientes = new Swiper('#swiper-blog', {
	speed: 500,
	spaceBetween: 0,
	slidesPerView: 1,
	autoplay: {
		delay: 5000,
		disableOnInteraction: false,
	},
	loop: true,
	pagination: {
		el: '.blog-pagination',
		type: 'bullets',
		clickable: true
	},
});
</script>